/* Autogenerated file. Do not edit manually. */
/* tslint:disable */
/* eslint-disable */

import {
  ethers,
  EventFilter,
  Signer,
  BigNumber,
  BigNumberish,
  PopulatedTransaction,
} from "ethers";
import {
  Contract,
  ContractTransaction,
  Overrides,
  PayableOverrides,
  CallOverrides,
} from "@ethersproject/contracts";
import { BytesLike } from "@ethersproject/bytes";
import { Listener, Provider } from "@ethersproject/providers";
import { FunctionFragment, EventFragment, Result } from "@ethersproject/abi";

interface PositionManagerInterface extends ethers.utils.Interface {
  functions: {
    "DOMAIN_SEPARATOR()": FunctionFragment;
    "approve(address,uint256)": FunctionFragment;
    "balanceOf(address)": FunctionFragment;
    "getApproved(uint256)": FunctionFragment;
    "getPoolAndPositionInfo(uint256)": FunctionFragment;
    "getPositionLiquidity(uint256)": FunctionFragment;
    "initializePool(tuple,uint160)": FunctionFragment;
    "isApprovedForAll(address,address)": FunctionFragment;
    "modifyLiquidities(bytes,uint256)": FunctionFragment;
    "modifyLiquiditiesWithoutUnlock(bytes,bytes[])": FunctionFragment;
    "msgSender()": FunctionFragment;
    "multicall(bytes[])": FunctionFragment;
    "name()": FunctionFragment;
    "nextTokenId()": FunctionFragment;
    "nonces(address,uint256)": FunctionFragment;
    "ownerOf(uint256)": FunctionFragment;
    "permit(address,uint256,uint256,uint256,bytes)": FunctionFragment;
    "permit2()": FunctionFragment;
    "permitBatch(address,tuple,bytes)": FunctionFragment;
    "permitForAll(address,address,bool,uint256,uint256,bytes)": FunctionFragment;
    "poolKeys(bytes25)": FunctionFragment;
    "poolManager()": FunctionFragment;
    "positionInfo(uint256)": FunctionFragment;
    "revokeNonce(uint256)": FunctionFragment;
    "safeTransferFrom(address,address,uint256)": FunctionFragment;
    "setApprovalForAll(address,bool)": FunctionFragment;
    "subscribe(uint256,address,bytes)": FunctionFragment;
    "subscriber(uint256)": FunctionFragment;
    "supportsInterface(bytes4)": FunctionFragment;
    "symbol()": FunctionFragment;
    "tokenDescriptor()": FunctionFragment;
    "tokenURI(uint256)": FunctionFragment;
    "transferFrom(address,address,uint256)": FunctionFragment;
    "unlockCallback(bytes)": FunctionFragment;
    "unsubscribe(uint256)": FunctionFragment;
    "unsubscribeGasLimit()": FunctionFragment;
  };

  encodeFunctionData(
    functionFragment: "DOMAIN_SEPARATOR",
    values?: undefined
  ): string;
  encodeFunctionData(
    functionFragment: "approve",
    values: [string, BigNumberish]
  ): string;
  encodeFunctionData(functionFragment: "balanceOf", values: [string]): string;
  encodeFunctionData(
    functionFragment: "getApproved",
    values: [BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "getPoolAndPositionInfo",
    values: [BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "getPositionLiquidity",
    values: [BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "initializePool",
    values: [
      {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      BigNumberish
    ]
  ): string;
  encodeFunctionData(
    functionFragment: "isApprovedForAll",
    values: [string, string]
  ): string;
  encodeFunctionData(
    functionFragment: "modifyLiquidities",
    values: [BytesLike, BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "modifyLiquiditiesWithoutUnlock",
    values: [BytesLike, BytesLike[]]
  ): string;
  encodeFunctionData(functionFragment: "msgSender", values?: undefined): string;
  encodeFunctionData(
    functionFragment: "multicall",
    values: [BytesLike[]]
  ): string;
  encodeFunctionData(functionFragment: "name", values?: undefined): string;
  encodeFunctionData(
    functionFragment: "nextTokenId",
    values?: undefined
  ): string;
  encodeFunctionData(
    functionFragment: "nonces",
    values: [string, BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "ownerOf",
    values: [BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "permit",
    values: [string, BigNumberish, BigNumberish, BigNumberish, BytesLike]
  ): string;
  encodeFunctionData(functionFragment: "permit2", values?: undefined): string;
  encodeFunctionData(
    functionFragment: "permitBatch",
    values: [
      string,
      {
        details: {
          token: string;
          amount: BigNumberish;
          expiration: BigNumberish;
          nonce: BigNumberish;
        }[];
        spender: string;
        sigDeadline: BigNumberish;
      },
      BytesLike
    ]
  ): string;
  encodeFunctionData(
    functionFragment: "permitForAll",
    values: [string, string, boolean, BigNumberish, BigNumberish, BytesLike]
  ): string;
  encodeFunctionData(functionFragment: "poolKeys", values: [BytesLike]): string;
  encodeFunctionData(
    functionFragment: "poolManager",
    values?: undefined
  ): string;
  encodeFunctionData(
    functionFragment: "positionInfo",
    values: [BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "revokeNonce",
    values: [BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "safeTransferFrom",
    values: [string, string, BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "setApprovalForAll",
    values: [string, boolean]
  ): string;
  encodeFunctionData(
    functionFragment: "subscribe",
    values: [BigNumberish, string, BytesLike]
  ): string;
  encodeFunctionData(
    functionFragment: "subscriber",
    values: [BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "supportsInterface",
    values: [BytesLike]
  ): string;
  encodeFunctionData(functionFragment: "symbol", values?: undefined): string;
  encodeFunctionData(
    functionFragment: "tokenDescriptor",
    values?: undefined
  ): string;
  encodeFunctionData(
    functionFragment: "tokenURI",
    values: [BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "transferFrom",
    values: [string, string, BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "unlockCallback",
    values: [BytesLike]
  ): string;
  encodeFunctionData(
    functionFragment: "unsubscribe",
    values: [BigNumberish]
  ): string;
  encodeFunctionData(
    functionFragment: "unsubscribeGasLimit",
    values?: undefined
  ): string;

  decodeFunctionResult(
    functionFragment: "DOMAIN_SEPARATOR",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "approve", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "balanceOf", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "getApproved",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "getPoolAndPositionInfo",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "getPositionLiquidity",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "initializePool",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "isApprovedForAll",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "modifyLiquidities",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "modifyLiquiditiesWithoutUnlock",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "msgSender", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "multicall", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "name", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "nextTokenId",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "nonces", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "ownerOf", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "permit", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "permit2", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "permitBatch",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "permitForAll",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "poolKeys", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "poolManager",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "positionInfo",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "revokeNonce",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "safeTransferFrom",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "setApprovalForAll",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "subscribe", data: BytesLike): Result;
  decodeFunctionResult(functionFragment: "subscriber", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "supportsInterface",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "symbol", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "tokenDescriptor",
    data: BytesLike
  ): Result;
  decodeFunctionResult(functionFragment: "tokenURI", data: BytesLike): Result;
  decodeFunctionResult(
    functionFragment: "transferFrom",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "unlockCallback",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "unsubscribe",
    data: BytesLike
  ): Result;
  decodeFunctionResult(
    functionFragment: "unsubscribeGasLimit",
    data: BytesLike
  ): Result;

  events: {
    "Approval(address,address,uint256)": EventFragment;
    "ApprovalForAll(address,address,bool)": EventFragment;
    "Subscription(uint256,address)": EventFragment;
    "Transfer(address,address,uint256)": EventFragment;
    "Unsubscription(uint256,address)": EventFragment;
  };

  getEvent(nameOrSignatureOrTopic: "Approval"): EventFragment;
  getEvent(nameOrSignatureOrTopic: "ApprovalForAll"): EventFragment;
  getEvent(nameOrSignatureOrTopic: "Subscription"): EventFragment;
  getEvent(nameOrSignatureOrTopic: "Transfer"): EventFragment;
  getEvent(nameOrSignatureOrTopic: "Unsubscription"): EventFragment;
}

export class PositionManager extends Contract {
  connect(signerOrProvider: Signer | Provider | string): this;
  attach(addressOrName: string): this;
  deployed(): Promise<this>;

  on(event: EventFilter | string, listener: Listener): this;
  once(event: EventFilter | string, listener: Listener): this;
  addListener(eventName: EventFilter | string, listener: Listener): this;
  removeAllListeners(eventName: EventFilter | string): this;
  removeListener(eventName: any, listener: Listener): this;

  interface: PositionManagerInterface;

  functions: {
    DOMAIN_SEPARATOR(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    "DOMAIN_SEPARATOR()"(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    approve(
      spender: string,
      id: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "approve(address,uint256)"(
      spender: string,
      id: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    balanceOf(
      owner: string,
      overrides?: CallOverrides
    ): Promise<{
      0: BigNumber;
    }>;

    "balanceOf(address)"(
      owner: string,
      overrides?: CallOverrides
    ): Promise<{
      0: BigNumber;
    }>;

    getApproved(
      arg0: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      0: string;
    }>;

    "getApproved(uint256)"(
      arg0: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      0: string;
    }>;

    getPoolAndPositionInfo(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      poolKey: {
        currency0: string;
        currency1: string;
        fee: number;
        tickSpacing: number;
        hooks: string;
        0: string;
        1: string;
        2: number;
        3: number;
        4: string;
      };
      info: BigNumber;
      0: {
        currency0: string;
        currency1: string;
        fee: number;
        tickSpacing: number;
        hooks: string;
        0: string;
        1: string;
        2: number;
        3: number;
        4: string;
      };
      1: BigNumber;
    }>;

    "getPoolAndPositionInfo(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      poolKey: {
        currency0: string;
        currency1: string;
        fee: number;
        tickSpacing: number;
        hooks: string;
        0: string;
        1: string;
        2: number;
        3: number;
        4: string;
      };
      info: BigNumber;
      0: {
        currency0: string;
        currency1: string;
        fee: number;
        tickSpacing: number;
        hooks: string;
        0: string;
        1: string;
        2: number;
        3: number;
        4: string;
      };
      1: BigNumber;
    }>;

    getPositionLiquidity(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      liquidity: BigNumber;
      0: BigNumber;
    }>;

    "getPositionLiquidity(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      liquidity: BigNumber;
      0: BigNumber;
    }>;

    initializePool(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      sqrtPriceX96: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    "initializePool((address,address,uint24,int24,address),uint160)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      sqrtPriceX96: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    isApprovedForAll(
      arg0: string,
      arg1: string,
      overrides?: CallOverrides
    ): Promise<{
      0: boolean;
    }>;

    "isApprovedForAll(address,address)"(
      arg0: string,
      arg1: string,
      overrides?: CallOverrides
    ): Promise<{
      0: boolean;
    }>;

    modifyLiquidities(
      unlockData: BytesLike,
      deadline: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    "modifyLiquidities(bytes,uint256)"(
      unlockData: BytesLike,
      deadline: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    modifyLiquiditiesWithoutUnlock(
      actions: BytesLike,
      params: BytesLike[],
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    "modifyLiquiditiesWithoutUnlock(bytes,bytes[])"(
      actions: BytesLike,
      params: BytesLike[],
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    msgSender(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    "msgSender()"(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    multicall(
      data: BytesLike[],
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    "multicall(bytes[])"(
      data: BytesLike[],
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    name(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    "name()"(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    nextTokenId(overrides?: CallOverrides): Promise<{
      0: BigNumber;
    }>;

    "nextTokenId()"(overrides?: CallOverrides): Promise<{
      0: BigNumber;
    }>;

    nonces(
      owner: string,
      word: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      bitmap: BigNumber;
      0: BigNumber;
    }>;

    "nonces(address,uint256)"(
      owner: string,
      word: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      bitmap: BigNumber;
      0: BigNumber;
    }>;

    ownerOf(
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      owner: string;
      0: string;
    }>;

    "ownerOf(uint256)"(
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      owner: string;
      0: string;
    }>;

    "permit(address,uint256,uint256,uint256,bytes)"(
      spender: string,
      tokenId: BigNumberish,
      deadline: BigNumberish,
      nonce: BigNumberish,
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    "permit(address,((address,uint160,uint48,uint48),address,uint256),bytes)"(
      owner: string,
      permitSingle: {
        details: {
          token: string;
          amount: BigNumberish;
          expiration: BigNumberish;
          nonce: BigNumberish;
        };
        spender: string;
        sigDeadline: BigNumberish;
      },
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    permit2(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    "permit2()"(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    permitBatch(
      owner: string,
      _permitBatch: {
        details: {
          token: string;
          amount: BigNumberish;
          expiration: BigNumberish;
          nonce: BigNumberish;
        }[];
        spender: string;
        sigDeadline: BigNumberish;
      },
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    "permitBatch(address,(tuple[],address,uint256),bytes)"(
      owner: string,
      _permitBatch: {
        details: {
          token: string;
          amount: BigNumberish;
          expiration: BigNumberish;
          nonce: BigNumberish;
        }[];
        spender: string;
        sigDeadline: BigNumberish;
      },
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    permitForAll(
      owner: string,
      operator: string,
      approved: boolean,
      deadline: BigNumberish,
      nonce: BigNumberish,
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    "permitForAll(address,address,bool,uint256,uint256,bytes)"(
      owner: string,
      operator: string,
      approved: boolean,
      deadline: BigNumberish,
      nonce: BigNumberish,
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    poolKeys(
      poolId: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      currency0: string;
      currency1: string;
      fee: number;
      tickSpacing: number;
      hooks: string;
      0: string;
      1: string;
      2: number;
      3: number;
      4: string;
    }>;

    "poolKeys(bytes25)"(
      poolId: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      currency0: string;
      currency1: string;
      fee: number;
      tickSpacing: number;
      hooks: string;
      0: string;
      1: string;
      2: number;
      3: number;
      4: string;
    }>;

    poolManager(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    "poolManager()"(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    positionInfo(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      info: BigNumber;
      0: BigNumber;
    }>;

    "positionInfo(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      info: BigNumber;
      0: BigNumber;
    }>;

    revokeNonce(
      nonce: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    "revokeNonce(uint256)"(
      nonce: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    "safeTransferFrom(address,address,uint256)"(
      from: string,
      to: string,
      id: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "safeTransferFrom(address,address,uint256,bytes)"(
      from: string,
      to: string,
      id: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    setApprovalForAll(
      operator: string,
      approved: boolean,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "setApprovalForAll(address,bool)"(
      operator: string,
      approved: boolean,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    subscribe(
      tokenId: BigNumberish,
      newSubscriber: string,
      data: BytesLike,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    "subscribe(uint256,address,bytes)"(
      tokenId: BigNumberish,
      newSubscriber: string,
      data: BytesLike,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    subscriber(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      subscriber: string;
      0: string;
    }>;

    "subscriber(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      subscriber: string;
      0: string;
    }>;

    supportsInterface(
      interfaceId: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      0: boolean;
    }>;

    "supportsInterface(bytes4)"(
      interfaceId: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      0: boolean;
    }>;

    symbol(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    "symbol()"(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    tokenDescriptor(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    "tokenDescriptor()"(overrides?: CallOverrides): Promise<{
      0: string;
    }>;

    tokenURI(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      0: string;
    }>;

    "tokenURI(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      0: string;
    }>;

    transferFrom(
      from: string,
      to: string,
      id: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "transferFrom(address,address,uint256)"(
      from: string,
      to: string,
      id: BigNumberish,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    unlockCallback(
      data: BytesLike,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    "unlockCallback(bytes)"(
      data: BytesLike,
      overrides?: Overrides
    ): Promise<ContractTransaction>;

    unsubscribe(
      tokenId: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    "unsubscribe(uint256)"(
      tokenId: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<ContractTransaction>;

    unsubscribeGasLimit(overrides?: CallOverrides): Promise<{
      0: BigNumber;
    }>;

    "unsubscribeGasLimit()"(overrides?: CallOverrides): Promise<{
      0: BigNumber;
    }>;
  };

  DOMAIN_SEPARATOR(overrides?: CallOverrides): Promise<string>;

  "DOMAIN_SEPARATOR()"(overrides?: CallOverrides): Promise<string>;

  approve(
    spender: string,
    id: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "approve(address,uint256)"(
    spender: string,
    id: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  balanceOf(owner: string, overrides?: CallOverrides): Promise<BigNumber>;

  "balanceOf(address)"(
    owner: string,
    overrides?: CallOverrides
  ): Promise<BigNumber>;

  getApproved(arg0: BigNumberish, overrides?: CallOverrides): Promise<string>;

  "getApproved(uint256)"(
    arg0: BigNumberish,
    overrides?: CallOverrides
  ): Promise<string>;

  getPoolAndPositionInfo(
    tokenId: BigNumberish,
    overrides?: CallOverrides
  ): Promise<{
    poolKey: {
      currency0: string;
      currency1: string;
      fee: number;
      tickSpacing: number;
      hooks: string;
      0: string;
      1: string;
      2: number;
      3: number;
      4: string;
    };
    info: BigNumber;
    0: {
      currency0: string;
      currency1: string;
      fee: number;
      tickSpacing: number;
      hooks: string;
      0: string;
      1: string;
      2: number;
      3: number;
      4: string;
    };
    1: BigNumber;
  }>;

  "getPoolAndPositionInfo(uint256)"(
    tokenId: BigNumberish,
    overrides?: CallOverrides
  ): Promise<{
    poolKey: {
      currency0: string;
      currency1: string;
      fee: number;
      tickSpacing: number;
      hooks: string;
      0: string;
      1: string;
      2: number;
      3: number;
      4: string;
    };
    info: BigNumber;
    0: {
      currency0: string;
      currency1: string;
      fee: number;
      tickSpacing: number;
      hooks: string;
      0: string;
      1: string;
      2: number;
      3: number;
      4: string;
    };
    1: BigNumber;
  }>;

  getPositionLiquidity(
    tokenId: BigNumberish,
    overrides?: CallOverrides
  ): Promise<BigNumber>;

  "getPositionLiquidity(uint256)"(
    tokenId: BigNumberish,
    overrides?: CallOverrides
  ): Promise<BigNumber>;

  initializePool(
    key: {
      currency0: string;
      currency1: string;
      fee: BigNumberish;
      tickSpacing: BigNumberish;
      hooks: string;
    },
    sqrtPriceX96: BigNumberish,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  "initializePool((address,address,uint24,int24,address),uint160)"(
    key: {
      currency0: string;
      currency1: string;
      fee: BigNumberish;
      tickSpacing: BigNumberish;
      hooks: string;
    },
    sqrtPriceX96: BigNumberish,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  isApprovedForAll(
    arg0: string,
    arg1: string,
    overrides?: CallOverrides
  ): Promise<boolean>;

  "isApprovedForAll(address,address)"(
    arg0: string,
    arg1: string,
    overrides?: CallOverrides
  ): Promise<boolean>;

  modifyLiquidities(
    unlockData: BytesLike,
    deadline: BigNumberish,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  "modifyLiquidities(bytes,uint256)"(
    unlockData: BytesLike,
    deadline: BigNumberish,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  modifyLiquiditiesWithoutUnlock(
    actions: BytesLike,
    params: BytesLike[],
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  "modifyLiquiditiesWithoutUnlock(bytes,bytes[])"(
    actions: BytesLike,
    params: BytesLike[],
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  msgSender(overrides?: CallOverrides): Promise<string>;

  "msgSender()"(overrides?: CallOverrides): Promise<string>;

  multicall(
    data: BytesLike[],
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  "multicall(bytes[])"(
    data: BytesLike[],
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  name(overrides?: CallOverrides): Promise<string>;

  "name()"(overrides?: CallOverrides): Promise<string>;

  nextTokenId(overrides?: CallOverrides): Promise<BigNumber>;

  "nextTokenId()"(overrides?: CallOverrides): Promise<BigNumber>;

  nonces(
    owner: string,
    word: BigNumberish,
    overrides?: CallOverrides
  ): Promise<BigNumber>;

  "nonces(address,uint256)"(
    owner: string,
    word: BigNumberish,
    overrides?: CallOverrides
  ): Promise<BigNumber>;

  ownerOf(id: BigNumberish, overrides?: CallOverrides): Promise<string>;

  "ownerOf(uint256)"(
    id: BigNumberish,
    overrides?: CallOverrides
  ): Promise<string>;

  "permit(address,uint256,uint256,uint256,bytes)"(
    spender: string,
    tokenId: BigNumberish,
    deadline: BigNumberish,
    nonce: BigNumberish,
    signature: BytesLike,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  "permit(address,((address,uint160,uint48,uint48),address,uint256),bytes)"(
    owner: string,
    permitSingle: {
      details: {
        token: string;
        amount: BigNumberish;
        expiration: BigNumberish;
        nonce: BigNumberish;
      };
      spender: string;
      sigDeadline: BigNumberish;
    },
    signature: BytesLike,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  permit2(overrides?: CallOverrides): Promise<string>;

  "permit2()"(overrides?: CallOverrides): Promise<string>;

  permitBatch(
    owner: string,
    _permitBatch: {
      details: {
        token: string;
        amount: BigNumberish;
        expiration: BigNumberish;
        nonce: BigNumberish;
      }[];
      spender: string;
      sigDeadline: BigNumberish;
    },
    signature: BytesLike,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  "permitBatch(address,(tuple[],address,uint256),bytes)"(
    owner: string,
    _permitBatch: {
      details: {
        token: string;
        amount: BigNumberish;
        expiration: BigNumberish;
        nonce: BigNumberish;
      }[];
      spender: string;
      sigDeadline: BigNumberish;
    },
    signature: BytesLike,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  permitForAll(
    owner: string,
    operator: string,
    approved: boolean,
    deadline: BigNumberish,
    nonce: BigNumberish,
    signature: BytesLike,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  "permitForAll(address,address,bool,uint256,uint256,bytes)"(
    owner: string,
    operator: string,
    approved: boolean,
    deadline: BigNumberish,
    nonce: BigNumberish,
    signature: BytesLike,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  poolKeys(
    poolId: BytesLike,
    overrides?: CallOverrides
  ): Promise<{
    currency0: string;
    currency1: string;
    fee: number;
    tickSpacing: number;
    hooks: string;
    0: string;
    1: string;
    2: number;
    3: number;
    4: string;
  }>;

  "poolKeys(bytes25)"(
    poolId: BytesLike,
    overrides?: CallOverrides
  ): Promise<{
    currency0: string;
    currency1: string;
    fee: number;
    tickSpacing: number;
    hooks: string;
    0: string;
    1: string;
    2: number;
    3: number;
    4: string;
  }>;

  poolManager(overrides?: CallOverrides): Promise<string>;

  "poolManager()"(overrides?: CallOverrides): Promise<string>;

  positionInfo(
    tokenId: BigNumberish,
    overrides?: CallOverrides
  ): Promise<BigNumber>;

  "positionInfo(uint256)"(
    tokenId: BigNumberish,
    overrides?: CallOverrides
  ): Promise<BigNumber>;

  revokeNonce(
    nonce: BigNumberish,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  "revokeNonce(uint256)"(
    nonce: BigNumberish,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  "safeTransferFrom(address,address,uint256)"(
    from: string,
    to: string,
    id: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "safeTransferFrom(address,address,uint256,bytes)"(
    from: string,
    to: string,
    id: BigNumberish,
    data: BytesLike,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  setApprovalForAll(
    operator: string,
    approved: boolean,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "setApprovalForAll(address,bool)"(
    operator: string,
    approved: boolean,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  subscribe(
    tokenId: BigNumberish,
    newSubscriber: string,
    data: BytesLike,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  "subscribe(uint256,address,bytes)"(
    tokenId: BigNumberish,
    newSubscriber: string,
    data: BytesLike,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  subscriber(tokenId: BigNumberish, overrides?: CallOverrides): Promise<string>;

  "subscriber(uint256)"(
    tokenId: BigNumberish,
    overrides?: CallOverrides
  ): Promise<string>;

  supportsInterface(
    interfaceId: BytesLike,
    overrides?: CallOverrides
  ): Promise<boolean>;

  "supportsInterface(bytes4)"(
    interfaceId: BytesLike,
    overrides?: CallOverrides
  ): Promise<boolean>;

  symbol(overrides?: CallOverrides): Promise<string>;

  "symbol()"(overrides?: CallOverrides): Promise<string>;

  tokenDescriptor(overrides?: CallOverrides): Promise<string>;

  "tokenDescriptor()"(overrides?: CallOverrides): Promise<string>;

  tokenURI(tokenId: BigNumberish, overrides?: CallOverrides): Promise<string>;

  "tokenURI(uint256)"(
    tokenId: BigNumberish,
    overrides?: CallOverrides
  ): Promise<string>;

  transferFrom(
    from: string,
    to: string,
    id: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "transferFrom(address,address,uint256)"(
    from: string,
    to: string,
    id: BigNumberish,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  unlockCallback(
    data: BytesLike,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  "unlockCallback(bytes)"(
    data: BytesLike,
    overrides?: Overrides
  ): Promise<ContractTransaction>;

  unsubscribe(
    tokenId: BigNumberish,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  "unsubscribe(uint256)"(
    tokenId: BigNumberish,
    overrides?: PayableOverrides
  ): Promise<ContractTransaction>;

  unsubscribeGasLimit(overrides?: CallOverrides): Promise<BigNumber>;

  "unsubscribeGasLimit()"(overrides?: CallOverrides): Promise<BigNumber>;

  callStatic: {
    DOMAIN_SEPARATOR(overrides?: CallOverrides): Promise<string>;

    "DOMAIN_SEPARATOR()"(overrides?: CallOverrides): Promise<string>;

    approve(
      spender: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    "approve(address,uint256)"(
      spender: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    balanceOf(owner: string, overrides?: CallOverrides): Promise<BigNumber>;

    "balanceOf(address)"(
      owner: string,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    getApproved(arg0: BigNumberish, overrides?: CallOverrides): Promise<string>;

    "getApproved(uint256)"(
      arg0: BigNumberish,
      overrides?: CallOverrides
    ): Promise<string>;

    getPoolAndPositionInfo(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      poolKey: {
        currency0: string;
        currency1: string;
        fee: number;
        tickSpacing: number;
        hooks: string;
        0: string;
        1: string;
        2: number;
        3: number;
        4: string;
      };
      info: BigNumber;
      0: {
        currency0: string;
        currency1: string;
        fee: number;
        tickSpacing: number;
        hooks: string;
        0: string;
        1: string;
        2: number;
        3: number;
        4: string;
      };
      1: BigNumber;
    }>;

    "getPoolAndPositionInfo(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<{
      poolKey: {
        currency0: string;
        currency1: string;
        fee: number;
        tickSpacing: number;
        hooks: string;
        0: string;
        1: string;
        2: number;
        3: number;
        4: string;
      };
      info: BigNumber;
      0: {
        currency0: string;
        currency1: string;
        fee: number;
        tickSpacing: number;
        hooks: string;
        0: string;
        1: string;
        2: number;
        3: number;
        4: string;
      };
      1: BigNumber;
    }>;

    getPositionLiquidity(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "getPositionLiquidity(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    initializePool(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      sqrtPriceX96: BigNumberish,
      overrides?: CallOverrides
    ): Promise<number>;

    "initializePool((address,address,uint24,int24,address),uint160)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      sqrtPriceX96: BigNumberish,
      overrides?: CallOverrides
    ): Promise<number>;

    isApprovedForAll(
      arg0: string,
      arg1: string,
      overrides?: CallOverrides
    ): Promise<boolean>;

    "isApprovedForAll(address,address)"(
      arg0: string,
      arg1: string,
      overrides?: CallOverrides
    ): Promise<boolean>;

    modifyLiquidities(
      unlockData: BytesLike,
      deadline: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    "modifyLiquidities(bytes,uint256)"(
      unlockData: BytesLike,
      deadline: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    modifyLiquiditiesWithoutUnlock(
      actions: BytesLike,
      params: BytesLike[],
      overrides?: CallOverrides
    ): Promise<void>;

    "modifyLiquiditiesWithoutUnlock(bytes,bytes[])"(
      actions: BytesLike,
      params: BytesLike[],
      overrides?: CallOverrides
    ): Promise<void>;

    msgSender(overrides?: CallOverrides): Promise<string>;

    "msgSender()"(overrides?: CallOverrides): Promise<string>;

    multicall(data: BytesLike[], overrides?: CallOverrides): Promise<string[]>;

    "multicall(bytes[])"(
      data: BytesLike[],
      overrides?: CallOverrides
    ): Promise<string[]>;

    name(overrides?: CallOverrides): Promise<string>;

    "name()"(overrides?: CallOverrides): Promise<string>;

    nextTokenId(overrides?: CallOverrides): Promise<BigNumber>;

    "nextTokenId()"(overrides?: CallOverrides): Promise<BigNumber>;

    nonces(
      owner: string,
      word: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "nonces(address,uint256)"(
      owner: string,
      word: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    ownerOf(id: BigNumberish, overrides?: CallOverrides): Promise<string>;

    "ownerOf(uint256)"(
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<string>;

    "permit(address,uint256,uint256,uint256,bytes)"(
      spender: string,
      tokenId: BigNumberish,
      deadline: BigNumberish,
      nonce: BigNumberish,
      signature: BytesLike,
      overrides?: CallOverrides
    ): Promise<void>;

    "permit(address,((address,uint160,uint48,uint48),address,uint256),bytes)"(
      owner: string,
      permitSingle: {
        details: {
          token: string;
          amount: BigNumberish;
          expiration: BigNumberish;
          nonce: BigNumberish;
        };
        spender: string;
        sigDeadline: BigNumberish;
      },
      signature: BytesLike,
      overrides?: CallOverrides
    ): Promise<string>;

    permit2(overrides?: CallOverrides): Promise<string>;

    "permit2()"(overrides?: CallOverrides): Promise<string>;

    permitBatch(
      owner: string,
      _permitBatch: {
        details: {
          token: string;
          amount: BigNumberish;
          expiration: BigNumberish;
          nonce: BigNumberish;
        }[];
        spender: string;
        sigDeadline: BigNumberish;
      },
      signature: BytesLike,
      overrides?: CallOverrides
    ): Promise<string>;

    "permitBatch(address,(tuple[],address,uint256),bytes)"(
      owner: string,
      _permitBatch: {
        details: {
          token: string;
          amount: BigNumberish;
          expiration: BigNumberish;
          nonce: BigNumberish;
        }[];
        spender: string;
        sigDeadline: BigNumberish;
      },
      signature: BytesLike,
      overrides?: CallOverrides
    ): Promise<string>;

    permitForAll(
      owner: string,
      operator: string,
      approved: boolean,
      deadline: BigNumberish,
      nonce: BigNumberish,
      signature: BytesLike,
      overrides?: CallOverrides
    ): Promise<void>;

    "permitForAll(address,address,bool,uint256,uint256,bytes)"(
      owner: string,
      operator: string,
      approved: boolean,
      deadline: BigNumberish,
      nonce: BigNumberish,
      signature: BytesLike,
      overrides?: CallOverrides
    ): Promise<void>;

    poolKeys(
      poolId: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      currency0: string;
      currency1: string;
      fee: number;
      tickSpacing: number;
      hooks: string;
      0: string;
      1: string;
      2: number;
      3: number;
      4: string;
    }>;

    "poolKeys(bytes25)"(
      poolId: BytesLike,
      overrides?: CallOverrides
    ): Promise<{
      currency0: string;
      currency1: string;
      fee: number;
      tickSpacing: number;
      hooks: string;
      0: string;
      1: string;
      2: number;
      3: number;
      4: string;
    }>;

    poolManager(overrides?: CallOverrides): Promise<string>;

    "poolManager()"(overrides?: CallOverrides): Promise<string>;

    positionInfo(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "positionInfo(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    revokeNonce(nonce: BigNumberish, overrides?: CallOverrides): Promise<void>;

    "revokeNonce(uint256)"(
      nonce: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    "safeTransferFrom(address,address,uint256)"(
      from: string,
      to: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    "safeTransferFrom(address,address,uint256,bytes)"(
      from: string,
      to: string,
      id: BigNumberish,
      data: BytesLike,
      overrides?: CallOverrides
    ): Promise<void>;

    setApprovalForAll(
      operator: string,
      approved: boolean,
      overrides?: CallOverrides
    ): Promise<void>;

    "setApprovalForAll(address,bool)"(
      operator: string,
      approved: boolean,
      overrides?: CallOverrides
    ): Promise<void>;

    subscribe(
      tokenId: BigNumberish,
      newSubscriber: string,
      data: BytesLike,
      overrides?: CallOverrides
    ): Promise<void>;

    "subscribe(uint256,address,bytes)"(
      tokenId: BigNumberish,
      newSubscriber: string,
      data: BytesLike,
      overrides?: CallOverrides
    ): Promise<void>;

    subscriber(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<string>;

    "subscriber(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<string>;

    supportsInterface(
      interfaceId: BytesLike,
      overrides?: CallOverrides
    ): Promise<boolean>;

    "supportsInterface(bytes4)"(
      interfaceId: BytesLike,
      overrides?: CallOverrides
    ): Promise<boolean>;

    symbol(overrides?: CallOverrides): Promise<string>;

    "symbol()"(overrides?: CallOverrides): Promise<string>;

    tokenDescriptor(overrides?: CallOverrides): Promise<string>;

    "tokenDescriptor()"(overrides?: CallOverrides): Promise<string>;

    tokenURI(tokenId: BigNumberish, overrides?: CallOverrides): Promise<string>;

    "tokenURI(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<string>;

    transferFrom(
      from: string,
      to: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    "transferFrom(address,address,uint256)"(
      from: string,
      to: string,
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    unlockCallback(data: BytesLike, overrides?: CallOverrides): Promise<string>;

    "unlockCallback(bytes)"(
      data: BytesLike,
      overrides?: CallOverrides
    ): Promise<string>;

    unsubscribe(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    "unsubscribe(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<void>;

    unsubscribeGasLimit(overrides?: CallOverrides): Promise<BigNumber>;

    "unsubscribeGasLimit()"(overrides?: CallOverrides): Promise<BigNumber>;
  };

  filters: {
    Approval(
      owner: string | null,
      spender: string | null,
      id: BigNumberish | null
    ): EventFilter;

    ApprovalForAll(
      owner: string | null,
      operator: string | null,
      approved: null
    ): EventFilter;

    Subscription(
      tokenId: BigNumberish | null,
      subscriber: string | null
    ): EventFilter;

    Transfer(
      from: string | null,
      to: string | null,
      id: BigNumberish | null
    ): EventFilter;

    Unsubscription(
      tokenId: BigNumberish | null,
      subscriber: string | null
    ): EventFilter;
  };

  estimateGas: {
    DOMAIN_SEPARATOR(overrides?: CallOverrides): Promise<BigNumber>;

    "DOMAIN_SEPARATOR()"(overrides?: CallOverrides): Promise<BigNumber>;

    approve(
      spender: string,
      id: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "approve(address,uint256)"(
      spender: string,
      id: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    balanceOf(owner: string, overrides?: CallOverrides): Promise<BigNumber>;

    "balanceOf(address)"(
      owner: string,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    getApproved(
      arg0: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "getApproved(uint256)"(
      arg0: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    getPoolAndPositionInfo(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "getPoolAndPositionInfo(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    getPositionLiquidity(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "getPositionLiquidity(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    initializePool(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      sqrtPriceX96: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    "initializePool((address,address,uint24,int24,address),uint160)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      sqrtPriceX96: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    isApprovedForAll(
      arg0: string,
      arg1: string,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "isApprovedForAll(address,address)"(
      arg0: string,
      arg1: string,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    modifyLiquidities(
      unlockData: BytesLike,
      deadline: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    "modifyLiquidities(bytes,uint256)"(
      unlockData: BytesLike,
      deadline: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    modifyLiquiditiesWithoutUnlock(
      actions: BytesLike,
      params: BytesLike[],
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    "modifyLiquiditiesWithoutUnlock(bytes,bytes[])"(
      actions: BytesLike,
      params: BytesLike[],
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    msgSender(overrides?: CallOverrides): Promise<BigNumber>;

    "msgSender()"(overrides?: CallOverrides): Promise<BigNumber>;

    multicall(
      data: BytesLike[],
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    "multicall(bytes[])"(
      data: BytesLike[],
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    name(overrides?: CallOverrides): Promise<BigNumber>;

    "name()"(overrides?: CallOverrides): Promise<BigNumber>;

    nextTokenId(overrides?: CallOverrides): Promise<BigNumber>;

    "nextTokenId()"(overrides?: CallOverrides): Promise<BigNumber>;

    nonces(
      owner: string,
      word: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "nonces(address,uint256)"(
      owner: string,
      word: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    ownerOf(id: BigNumberish, overrides?: CallOverrides): Promise<BigNumber>;

    "ownerOf(uint256)"(
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "permit(address,uint256,uint256,uint256,bytes)"(
      spender: string,
      tokenId: BigNumberish,
      deadline: BigNumberish,
      nonce: BigNumberish,
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    "permit(address,((address,uint160,uint48,uint48),address,uint256),bytes)"(
      owner: string,
      permitSingle: {
        details: {
          token: string;
          amount: BigNumberish;
          expiration: BigNumberish;
          nonce: BigNumberish;
        };
        spender: string;
        sigDeadline: BigNumberish;
      },
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    permit2(overrides?: CallOverrides): Promise<BigNumber>;

    "permit2()"(overrides?: CallOverrides): Promise<BigNumber>;

    permitBatch(
      owner: string,
      _permitBatch: {
        details: {
          token: string;
          amount: BigNumberish;
          expiration: BigNumberish;
          nonce: BigNumberish;
        }[];
        spender: string;
        sigDeadline: BigNumberish;
      },
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    "permitBatch(address,(tuple[],address,uint256),bytes)"(
      owner: string,
      _permitBatch: {
        details: {
          token: string;
          amount: BigNumberish;
          expiration: BigNumberish;
          nonce: BigNumberish;
        }[];
        spender: string;
        sigDeadline: BigNumberish;
      },
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    permitForAll(
      owner: string,
      operator: string,
      approved: boolean,
      deadline: BigNumberish,
      nonce: BigNumberish,
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    "permitForAll(address,address,bool,uint256,uint256,bytes)"(
      owner: string,
      operator: string,
      approved: boolean,
      deadline: BigNumberish,
      nonce: BigNumberish,
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    poolKeys(poolId: BytesLike, overrides?: CallOverrides): Promise<BigNumber>;

    "poolKeys(bytes25)"(
      poolId: BytesLike,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    poolManager(overrides?: CallOverrides): Promise<BigNumber>;

    "poolManager()"(overrides?: CallOverrides): Promise<BigNumber>;

    positionInfo(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "positionInfo(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    revokeNonce(
      nonce: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    "revokeNonce(uint256)"(
      nonce: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    "safeTransferFrom(address,address,uint256)"(
      from: string,
      to: string,
      id: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "safeTransferFrom(address,address,uint256,bytes)"(
      from: string,
      to: string,
      id: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<BigNumber>;

    setApprovalForAll(
      operator: string,
      approved: boolean,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "setApprovalForAll(address,bool)"(
      operator: string,
      approved: boolean,
      overrides?: Overrides
    ): Promise<BigNumber>;

    subscribe(
      tokenId: BigNumberish,
      newSubscriber: string,
      data: BytesLike,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    "subscribe(uint256,address,bytes)"(
      tokenId: BigNumberish,
      newSubscriber: string,
      data: BytesLike,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    subscriber(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "subscriber(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    supportsInterface(
      interfaceId: BytesLike,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "supportsInterface(bytes4)"(
      interfaceId: BytesLike,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    symbol(overrides?: CallOverrides): Promise<BigNumber>;

    "symbol()"(overrides?: CallOverrides): Promise<BigNumber>;

    tokenDescriptor(overrides?: CallOverrides): Promise<BigNumber>;

    "tokenDescriptor()"(overrides?: CallOverrides): Promise<BigNumber>;

    tokenURI(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    "tokenURI(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<BigNumber>;

    transferFrom(
      from: string,
      to: string,
      id: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    "transferFrom(address,address,uint256)"(
      from: string,
      to: string,
      id: BigNumberish,
      overrides?: Overrides
    ): Promise<BigNumber>;

    unlockCallback(data: BytesLike, overrides?: Overrides): Promise<BigNumber>;

    "unlockCallback(bytes)"(
      data: BytesLike,
      overrides?: Overrides
    ): Promise<BigNumber>;

    unsubscribe(
      tokenId: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    "unsubscribe(uint256)"(
      tokenId: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<BigNumber>;

    unsubscribeGasLimit(overrides?: CallOverrides): Promise<BigNumber>;

    "unsubscribeGasLimit()"(overrides?: CallOverrides): Promise<BigNumber>;
  };

  populateTransaction: {
    DOMAIN_SEPARATOR(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    "DOMAIN_SEPARATOR()"(
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    approve(
      spender: string,
      id: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "approve(address,uint256)"(
      spender: string,
      id: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    balanceOf(
      owner: string,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "balanceOf(address)"(
      owner: string,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    getApproved(
      arg0: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "getApproved(uint256)"(
      arg0: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    getPoolAndPositionInfo(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "getPoolAndPositionInfo(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    getPositionLiquidity(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "getPositionLiquidity(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    initializePool(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      sqrtPriceX96: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    "initializePool((address,address,uint24,int24,address),uint160)"(
      key: {
        currency0: string;
        currency1: string;
        fee: BigNumberish;
        tickSpacing: BigNumberish;
        hooks: string;
      },
      sqrtPriceX96: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    isApprovedForAll(
      arg0: string,
      arg1: string,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "isApprovedForAll(address,address)"(
      arg0: string,
      arg1: string,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    modifyLiquidities(
      unlockData: BytesLike,
      deadline: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    "modifyLiquidities(bytes,uint256)"(
      unlockData: BytesLike,
      deadline: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    modifyLiquiditiesWithoutUnlock(
      actions: BytesLike,
      params: BytesLike[],
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    "modifyLiquiditiesWithoutUnlock(bytes,bytes[])"(
      actions: BytesLike,
      params: BytesLike[],
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    msgSender(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    "msgSender()"(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    multicall(
      data: BytesLike[],
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    "multicall(bytes[])"(
      data: BytesLike[],
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    name(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    "name()"(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    nextTokenId(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    "nextTokenId()"(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    nonces(
      owner: string,
      word: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "nonces(address,uint256)"(
      owner: string,
      word: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    ownerOf(
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "ownerOf(uint256)"(
      id: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "permit(address,uint256,uint256,uint256,bytes)"(
      spender: string,
      tokenId: BigNumberish,
      deadline: BigNumberish,
      nonce: BigNumberish,
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    "permit(address,((address,uint160,uint48,uint48),address,uint256),bytes)"(
      owner: string,
      permitSingle: {
        details: {
          token: string;
          amount: BigNumberish;
          expiration: BigNumberish;
          nonce: BigNumberish;
        };
        spender: string;
        sigDeadline: BigNumberish;
      },
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    permit2(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    "permit2()"(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    permitBatch(
      owner: string,
      _permitBatch: {
        details: {
          token: string;
          amount: BigNumberish;
          expiration: BigNumberish;
          nonce: BigNumberish;
        }[];
        spender: string;
        sigDeadline: BigNumberish;
      },
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    "permitBatch(address,(tuple[],address,uint256),bytes)"(
      owner: string,
      _permitBatch: {
        details: {
          token: string;
          amount: BigNumberish;
          expiration: BigNumberish;
          nonce: BigNumberish;
        }[];
        spender: string;
        sigDeadline: BigNumberish;
      },
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    permitForAll(
      owner: string,
      operator: string,
      approved: boolean,
      deadline: BigNumberish,
      nonce: BigNumberish,
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    "permitForAll(address,address,bool,uint256,uint256,bytes)"(
      owner: string,
      operator: string,
      approved: boolean,
      deadline: BigNumberish,
      nonce: BigNumberish,
      signature: BytesLike,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    poolKeys(
      poolId: BytesLike,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "poolKeys(bytes25)"(
      poolId: BytesLike,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    poolManager(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    "poolManager()"(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    positionInfo(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "positionInfo(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    revokeNonce(
      nonce: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    "revokeNonce(uint256)"(
      nonce: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    "safeTransferFrom(address,address,uint256)"(
      from: string,
      to: string,
      id: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "safeTransferFrom(address,address,uint256,bytes)"(
      from: string,
      to: string,
      id: BigNumberish,
      data: BytesLike,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    setApprovalForAll(
      operator: string,
      approved: boolean,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "setApprovalForAll(address,bool)"(
      operator: string,
      approved: boolean,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    subscribe(
      tokenId: BigNumberish,
      newSubscriber: string,
      data: BytesLike,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    "subscribe(uint256,address,bytes)"(
      tokenId: BigNumberish,
      newSubscriber: string,
      data: BytesLike,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    subscriber(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "subscriber(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    supportsInterface(
      interfaceId: BytesLike,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "supportsInterface(bytes4)"(
      interfaceId: BytesLike,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    symbol(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    "symbol()"(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    tokenDescriptor(overrides?: CallOverrides): Promise<PopulatedTransaction>;

    "tokenDescriptor()"(
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    tokenURI(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "tokenURI(uint256)"(
      tokenId: BigNumberish,
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    transferFrom(
      from: string,
      to: string,
      id: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "transferFrom(address,address,uint256)"(
      from: string,
      to: string,
      id: BigNumberish,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    unlockCallback(
      data: BytesLike,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    "unlockCallback(bytes)"(
      data: BytesLike,
      overrides?: Overrides
    ): Promise<PopulatedTransaction>;

    unsubscribe(
      tokenId: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    "unsubscribe(uint256)"(
      tokenId: BigNumberish,
      overrides?: PayableOverrides
    ): Promise<PopulatedTransaction>;

    unsubscribeGasLimit(
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;

    "unsubscribeGasLimit()"(
      overrides?: CallOverrides
    ): Promise<PopulatedTransaction>;
  };
}
